package furny.states;

import ga.core.evaluation.IInteractiveFitnessEvaluator;
import ga.core.individual.IIndividual;
import ga.view.appstate.menu.IMenuListenerParent;
import ga.view.appstate.menu.MenuListener;

import java.util.logging.Logger;

import de.lessvoid.nifty.screen.DefaultScreenController;

/**
 * This is a controller that allows communication with the nifty gui.
 * 
 * @param <T>
 *          The generic type of the individuals.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class SummaryUIController<T extends IIndividual<T>> extends
    DefaultScreenController implements IMenuListenerParent {

  // the logger for this class
  private static final Logger LOGGER = Logger
      .getLogger(SummaryUIController.class.getName());

  private final IInteractiveFitnessEvaluator<T> evaluator;

  private MenuListener menuListener;

  /**
   * Instantiates a new summary ui controller.
   * 
   * @param evaluator
   *          the evaluator
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public SummaryUIController(final IInteractiveFitnessEvaluator<T> evaluator) {
    this.evaluator = evaluator;
  }

  @Override
  public void setMenuListener(final MenuListener menuListener) {
    this.menuListener = menuListener;
  }

  /**
   * Callback method. Called from the gui.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public void onTerminate() {
    if (menuListener != null) {
      menuListener.nextState();
    }
  }
}
